/*
 * Decompiled with CFR 0.152.
 */
package pse.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;
import pse.common.CommonObject;
import pse.util.general.XmlUtils;
import pse.util.general.XmlWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetworkConfiguration
extends CommonObject {
    protected List<String> deviceNames = new ArrayList<String>();
    protected Map<String, Map<String, String>> configurations = new HashMap<String, Map<String, String>>();
    protected Map<String, String> types = new HashMap<String, String>();

    @Override
    public String getElementName() {
        return "network-configuration";
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.configurations.isEmpty() || !this.types.isEmpty();
    }

    public boolean includesDeviceName(String string) {
        return this.deviceNames.contains(string);
    }

    public List<String> getDeviceNames() {
        return this.deviceNames;
    }

    public List<String> getConfigurationCommands(String string) {
        Map<String, String> map = this.configurations.get(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (map != null) {
            arrayList.addAll(map.keySet());
        }
        return arrayList;
    }

    public String getConfiguration(String string, String string2) {
        Map<String, String> map = this.configurations.get(string);
        return map == null ? "" : map.get(string2);
    }

    public String getType(String string) {
        return this.types.get(string);
    }

    public void addDevice(String string, String string2) {
        this.deviceNames.add(string);
        this.types.put(string, string2);
    }

    public void addConfiguration(String string, String string2, String string3) {
        Map<String, String> map = this.configurations.get(string);
        if (map == null) {
            map = new HashMap<String, String>();
            this.configurations.put(string, map);
        }
        map.put(string2, string3);
    }

    @Override
    protected void addChildren(XmlWriter xmlWriter) {
        super.addChildren(xmlWriter);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : this.deviceNames) {
            Map<String, String> map = this.configurations.get(string);
            if (map == null) continue;
            xmlWriter.openElement("device-configuration", "name", string, "type", this.getType(string));
            arrayList.clear();
            arrayList.addAll(map.keySet());
            Collections.sort(arrayList);
            for (String string2 : arrayList) {
                String string3 = map.get(string2);
                xmlWriter.openElement("device-info", "command", string2);
                xmlWriter.addCData(string3);
                xmlWriter.closeElement();
            }
            xmlWriter.closeElement();
        }
    }

    @Override
    protected void readChildrenFromMyNode(Node node) {
        super.readChildrenFromMyNode(node);
        List<Node> list = XmlUtils.getNodeChildren(node, "device-configuration");
        for (Node node2 : list) {
            String string = XmlUtils.getAttribute(node2, "name");
            String string2 = XmlUtils.getAttribute(node2, "type");
            this.addDevice(string, string2);
            List<Node> list2 = XmlUtils.getNodeChildren(node2, "device-info");
            for (Node node3 : list2) {
                String string3 = XmlUtils.getAttribute(node3, "command");
                String string4 = XmlUtils.getTransitiveText(node3);
                this.addConfiguration(string, string3, string4);
            }
        }
    }
}

